/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

public class ScriptSystem {
    public static final int ARMENIAN = 1328;
    public static final int COPTIC = 11392;
    public static final int CYRILLIC = 1024;
    public static final int GEORGIAN = 4256;
    public static final int GREEK = 880;
    public static final int LATIN = 0;
    public static final int ETHIOPIC = 4608;
    public static final int TIFINAGH = 11568;
    public static final int ARABIC = 1536;
    public static final int HEBREW = 1424;
    public static final int SYRIAC = 1792;
    public static final int THAANA = 1920;
    public static final int CANADIAN_SYLLABICS = 5120;
    public static final int CHEROKEE = 5024;
    public static final int DESERET = 66560;
    public static final int SHAVIAN = 66640;
    public static final int OSMANYA = 66688;
    public static final int BENGALI = 2432;
    public static final int DEVANAGARI = 2304;
    public static final int GUJARATI = 2688;
    public static final int GURMUKHI = 2560;
    public static final int KANNADA = 3200;
    public static final int LIMBU = 6400;
    public static final int MALAYALAM = 3328;
    public static final int ORIYA = 2816;
    public static final int SINHALA = 3456;
    public static final int TAMIL = 2944;
    public static final int TELUGU = 3072;
    public static final int KHMER = 6016;
    public static final int LAO = 3712;
    public static final int MYANMAR = 4096;
    public static final int TAI_LE = 6480;
    public static final int THAI = 3584;
    public static final int HAN = 11904;
    public static final int BOPOMOFO = 12544;
    public static final int HIRAGANA = 12352;
    public static final int KATAKANA = 12448;
    public static final int HANGUL = 4352;
    public static final int YI = 40960;
    public static final int MONGOLIAN = 6144;
    public static final int TIBETAN = 3840;
    public static final int RUNIC = 5792;
    private static final Spec[] systems = new Spec[]{new Spec(1328, new int[]{1328, 1423}, 1362, 0), new Spec(11392, new int[]{11392, 11519}, 11424, 0), new Spec(1024, new int[]{1024, 1327}, 1053, 0), new Spec(4256, new int[]{4256, 4351}, 4260, 0), new Spec(880, new int[]{880, 1008, 7936, 8191}, 926, 0), new Spec(0, new int[]{0, 687, 7424, 7551, 7680, 7935, 64256, 64335}, 73, 0), new Spec(4608, new int[]{4608, 5023, 11648, 11743}, 4704, 0), new Spec(11568, new int[]{11568, 11647}, 11594, 0), new Spec(1536, new int[]{1536, 1791, 64336, 65023, 65136, 65279}, 1697, 0), new Spec(1424, new int[]{1424, 1535}, 1491, 0), new Spec(1792, new int[]{1792, 1871}, 1814, 0), new Spec(1920, new int[]{1920, 1983}, 1922, 0), new Spec(2304, new int[]{2304, 2431}, 2327, 0), new Spec(2688, new int[]{2688, 2815}, 2750, 0), new Spec(2560, new int[]{2560, 2687}, 2616, 0), new Spec(2944, new int[]{2944, 2959}, 2986, 0), new Spec(3584, new int[]{3584, 3696}, 3610, 0), new Spec(11904, new int[]{11904, 4095, 12688, 12703, 19968, 40959, 63744, 64255, 13312, 19903, 131072, 173791, 194560, 195088}, 12033, 0), new Spec(12544, new int[]{12544, 12591, 12704, 12735}, 12551, 0), new Spec(12352, new int[]{12352, 12447}, 12379, 0), new Spec(12448, new int[]{12448, 12543, 65280, 65504, 12784, 12799}, 12529, 0), new Spec(4352, new int[]{4352, 4592}, 4352, 0), new Spec(40960, new int[]{40960, 42191}, 42128, 0), new Spec(6144, new int[]{6144, 6304}, 6274, 0), new Spec(3840, new int[]{3840, 4095}, 3910, 0), new Spec(5792, new int[]{5792, 5887}, 5825, 0)};

    private ScriptSystem() {
    }

    public static int getScriptSystemOf(char ch) {
        int n = systems.length;
        for (int i = 0; i < n; ++i) {
            int m = ScriptSystem.systems[i].ranges.length;
            for (int j = 0; j < m; j += 2) {
                if (ch < ScriptSystem.systems[i].ranges[j] || ch > ScriptSystem.systems[i].ranges[j + 1]) continue;
                return ScriptSystem.systems[i].system;
            }
        }
        return 0;
    }

    public static char getMeasurementChar(int system) {
        int n = systems.length;
        for (int i = 0; i < n; ++i) {
            if (ScriptSystem.systems[i].system != system) continue;
            return ScriptSystem.systems[i].measurementChar;
        }
        return 'X';
    }

    public static int getBaseline(int system) {
        int n = systems.length;
        for (int i = 0; i < n; ++i) {
            if (ScriptSystem.systems[i].system != system) continue;
            return ScriptSystem.systems[i].baseline;
        }
        return 0;
    }

    private static class Spec {
        int[] ranges;
        int system;
        char measurementChar;
        int baseline;

        public Spec(int system, int[] ranges, int measurementChar, int baseline) {
            this.system = system;
            this.ranges = ranges;
            this.measurementChar = (char)measurementChar;
            this.baseline = baseline;
        }
    }
}

